unit Line;
{*******************************************************************************
  ShapesDemo
  Written by David Clegg, davidclegg@optusnet.com.au.

  This unit contains the Line class used to render a line onto a GDI+ drawing
  surface.
*******************************************************************************}

interface

uses
  Shape, System.Drawing, System.Drawing.Drawing2D;

type

  /// <summary>
  /// Class to draw a Line.
  /// </summary>
  TLine = class(TShape)
  protected
    function GetShape(pStartPoint, pEndPoint: Point): GraphicsPath; override;
  public
    procedure DrawLine(pPen: Pen; pStartPoint, pEndPoint: Point);
  end;

implementation

/// <summary>
/// Create a GraphicsPath object representing the bounds for the Line
/// </summary>
function TLine.GetShape(pStartPoint,pEndPoint: Point): GraphicsPath;
begin
  Result := GraphicsPath.Create;
  Result.AddLine(pStartPoint, pEndPoint);
end;

/// <summary>
/// Alternative method to draw a Line.
/// </summary>
procedure TLine.DrawLine(pPen: Pen; pStartPoint, pEndPoint: Point);
begin
  Canvas.DrawLine(pPen, pStartPoint, pEndPoint);
end;

end.
